# Artale 数据同步服务器 - PHP版本

这是一个基于PHP的数据同步服务器实现，用于为Artale客户端提供地图、怪物数据和文件的同步服务。

## 功能特性

- 🔄 **数据同步**: 支持地图、怪物数据和配置文件的同步
- 📁 **文件管理**: 自动扫描和管理服务器端文件
- 🔒 **安全验证**: 文件哈希验证确保数据完整性
- 🌐 **RESTful API**: 标准的HTTP API接口
- 📦 **增量更新**: 只传输有变化的文件
- 🚀 **高性能**: 优化的文件传输和缓存机制

## 系统要求

### 基本要求
- **PHP**: 7.4 或更高版本
- **Web服务器**: Apache 2.4+ 或 Nginx 1.18+
- **扩展**: json, hash (必需)
- **可选扩展**: yaml (推荐，用于更好的YAML支持)

### 推荐配置
- **PHP**: 8.1+
- **内存**: 512MB+
- **磁盘空间**: 根据数据文件大小而定
- **网络**: 稳定的互联网连接

## 快速开始

### 1. 下载和解压

将服务器文件上传到您的Web服务器目录：

```bash
# 假设您的Web根目录是 /var/www/html
cd /var/www/html
mkdir artale-sync
cd artale-sync
# 上传所有PHP文件到此目录
```

### 2. 运行设置脚本

```bash
# 在浏览器中访问或通过命令行运行
php setup.php
```

或者在浏览器中访问：`http://your-domain.com/artale-sync/setup.php`

### 3. 配置Web服务器

#### Apache配置

确保启用了以下模块：
```bash
sudo a2enmod rewrite
sudo a2enmod headers
sudo systemctl restart apache2
```

项目已包含 `.htaccess` 文件，无需额外配置。

#### Nginx配置

将提供的 `nginx.conf` 配置添加到您的Nginx配置中：

```bash
sudo cp nginx.conf /etc/nginx/sites-available/artale-sync
sudo ln -s /etc/nginx/sites-available/artale-sync /etc/nginx/sites-enabled/
sudo nginx -t
sudo systemctl reload nginx
```

### 4. 上传数据文件

将您的数据文件按以下结构组织：

```
server_data/
├── config_data.yaml          # 配置文件
├── minimaps/                 # 小地图目录
│   ├── map1/
│   │   ├── route1.png
│   │   └── route2.png
│   └── map2/
│       └── route1.png
└── monsters/                 # 怪物目录
    ├── monster1/
    │   ├── monster1_1.png
    │   └── monster1_2.png
    └── monster2/
        └── monster2_1.png
```

### 5. 测试服务器

访问服务器主页：`http://your-domain.com/artale-sync/`

您应该看到服务器状态信息和可用的API端点。

## API文档

### 检查更新

**端点**: `POST /api/sync/check`

**请求体**:
```json
{
  "config_data": {
    "hash": "existing_config_hash"
  },
  "minimaps": {
    "map_name": {
      "file1.png": "existing_file_hash",
      "file2.png": "existing_file_hash"
    }
  },
  "monsters": {
    "monster_name": {
      "monster1.png": "existing_file_hash"
    }
  }
}
```

**响应**:
```json
{
  "has_updates": true,
  "config_data": {
    "hash": "new_config_hash",
    "download_url": "http://your-domain.com/download.php?type=config"
  },
  "minimaps": {
    "map_name": {
      "files": {
        "new_file.png": {
          "hash": "new_file_hash",
          "download_url": "http://your-domain.com/download.php?type=minimap&map=map_name&file=new_file.png"
        }
      }
    }
  },
  "monsters": {}
}
```

### 获取服务器状态

**端点**: `GET /api/sync/status`

**响应**:
```json
{
  "server_time": "2024-01-01T12:00:00+00:00",
  "maps_count": 5,
  "monsters_count": 10,
  "config_available": true
}
```

### 下载文件

#### 下载配置文件
**端点**: `GET /download.php?type=config`

#### 下载小地图文件
**端点**: `GET /download.php?type=minimap&map=<map_name>&file=<file_name>`

#### 下载怪物文件
**端点**: `GET /download.php?type=monster&monster=<monster_name>&file=<file_name>`

## 配置文件格式

`server_data/config_data.yaml` 文件格式：

```yaml
# 英文名到中文名的映射
eng_to_cn:
  map_english_name: "地图中文名"
  monster_english_name: "怪物中文名"

# 地图与怪物的绑定关系
map_mobs_mapping:
  map_english_name:
    - "monster1_english_name"
    - "monster2_english_name"
```

## 安全考虑

### 文件访问控制
- 配置文件 (`.yaml`, `.yml`) 被Web服务器配置阻止直接访问
- 只能通过API端点访问数据文件
- 实施了路径遍历攻击防护

### 文件类型限制
- 只允许下载特定类型的图片文件 (`.png`, `.jpg`, `.jpeg`)
- 严格验证文件路径和名称

### CORS配置
- 配置了适当的CORS头以支持跨域请求
- 可根据需要调整允许的域名

### 生产环境建议
1. **使用HTTPS**: 配置SSL证书保护数据传输
2. **访问控制**: 限制setup.php的访问
3. **监控**: 设置日志监控和错误报告
4. **备份**: 定期备份数据文件
5. **更新**: 保持PHP和Web服务器版本更新

## 故障排除

### 常见问题

#### 1. 404错误
- 检查Web服务器配置
- 确保URL重写规则正确
- 验证文件权限

#### 2. 文件下载失败
- 检查文件是否存在
- 验证文件权限
- 查看Web服务器错误日志

#### 3. YAML解析错误
- 安装yaml扩展：`sudo apt-get install php-yaml`
- 检查YAML文件格式
- 确保文件编码为UTF-8

#### 4. 权限问题
```bash
# 设置正确的文件权限
sudo chown -R www-data:www-data /path/to/artale-sync
sudo chmod -R 755 /path/to/artale-sync
sudo chmod -R 644 /path/to/artale-sync/server_data
```

### 调试模式

在开发环境中，可以启用PHP错误显示：

```php
// 在index.php顶部添加
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
```

### 日志查看

```bash
# Apache错误日志
sudo tail -f /var/log/apache2/error.log

# Nginx错误日志
sudo tail -f /var/log/nginx/artale_sync_error.log

# PHP错误日志
sudo tail -f /var/log/php/error.log
```

## 性能优化

### 缓存配置
- 启用静态文件缓存
- 配置适当的过期时间
- 使用CDN加速文件分发

### PHP优化
```ini
; php.ini 优化建议
memory_limit = 512M
max_execution_time = 300
upload_max_filesize = 100M
post_max_size = 100M
```

### 数据库优化（可选）
如果数据量很大，可以考虑使用数据库存储文件元信息：
- MySQL/PostgreSQL用于存储文件哈希和元数据
- Redis用于缓存频繁访问的数据

## 扩展功能

### 版本控制
可以扩展系统支持版本控制：
- 为每个数据更新分配版本号
- 支持回滚到之前的版本
- 提供版本历史查询

### 用户认证
为了更好的安全性，可以添加用户认证：
- API密钥验证
- JWT令牌认证
- 用户权限管理

### 统计分析
添加使用统计功能：
- 下载次数统计
- 用户活跃度分析
- 错误率监控

## 许可证

本项目遵循与主项目相同的许可证。

## 支持

如有问题或建议，请：
1. 查看本文档的故障排除部分
2. 检查Web服务器错误日志
3. 在项目仓库提交Issue

---

**注意**: 这是一个基础实现，生产环境使用时请根据实际需求进行安全加固和性能优化。